<?php
/**
 *          Version 1.0
 *          1. If you are NOT working with a child theme replace all instances of
 *          get_stylesheet_directory_uri() with get_template_directory_uri()
 *
 *          2. (optional but recommended) Limit the chart to display on a page or post
 *          http://codex.wordpress.org/Function_Reference/is_page
 *          http://codex.wordpress.org/Function_Reference/is_single
 *
 */

/**
 * Enqueue our JS
 */
function map_chart(){
    //if (is_page(68)){ Highly recommend limiting to post (is_single) or page(is_page)
                wp_enqueue_script('chart', 'https://www.google.com/jsapi');
                wp_enqueue_script('chart_main', get_stylesheet_directory_uri(). ' /js/chart-map.js', array('jquery'));

//}
}
    add_action( 'wp_enqueue_scripts', 'map_chart' );
    add_action( 'wp_ajax_build_map', 'build_map' );//admin
    add_action('wp_ajax_nopriv_build_map', 'build_map');//frontend

/**
 *
 * Function get_csv()
 *     1. default - parse local CSV file (data folder)
 *
 *     2. or fetch URL of the GDrive document providing that it is in a shared folder and is published to            the web as a CSV
 *
 * @return json encoded data
 */

function get_csv(){

//Get the CSV file - default or replace with your GDrive URL
$url = get_stylesheet_directory_uri().'/data/map_data.csv';

//$url= 'https://docs.google.com/spreadsheets/output=csv';

// Request the data from the CSV file
$request =   wp_safe_remote_get($url);
$response = wp_remote_retrieve_body( $request );

//Convert the data to an array
$data = array_map("str_getcsv", explode("\n", $response));

//Count how many rows
$count = count($data);

//Use first row for names
$labels = array_shift($data);

//Use labels as keys
foreach ($labels as $label) {
  $keys[] = $label;
}
//create array with key[id]/value of count -1 as we shifted top row for headers
    for ($i = 0; $i < $count-1; $i++) {
        $idVal[]  = $i;//values
        $idKey[] = 'id';//key
        $id_array[] = array_combine($idKey,$idVal);//combine both
    }

 //combine the labels key with the existing data
 foreach($data as $d) {
        $newArray[] = array_combine($keys, $d);
}
//Merge both arrays together
foreach($newArray as $key => $value){
    $result[$key] = array_merge($id_array[$key], $newArray[$key]);
}
//uses built in wp_json_encode to decode data and return the result
return wp_json_encode($result);

}

/**
  Function build_map is fetched by the javascript ajax request and uses the  get_csv() function
 */
function build_map(){
        $data = get_csv();// gets the CSV data
    echo $data;
die();
}
?>
