var $j = jQuery;
var mapColor;

// Load the Visualization API and the chart package.
google.load("visualization", "1", {
    packages: ["geochart"]
});

// Set a callback to run when the Google Visualization API is loaded.
google.setOnLoadCallback(drawRegionsMap);


//Create our Chart through an Ajax request by passing the build_map action which will be parsed with the build_map function in functions.php

function drawRegionsMap() {
    $j.ajax({
        url: ajaxurl,
        data: {
            "action": "build_map" //run build_map function in functions.php
        },
        dataType: "json",
    }).done(function (csv) {
        var data = new google.visualization.DataTable();
        data.addColumn('string', 'Country');
        data.addColumn('number', 'id');// The id  associates the color field
        data.addColumn({
            type: 'string',
            role: 'tooltip'
        });
        mapColor = [];

        $j.each(csv, function (i, item) {//jquery each function

            data.addRows([[{
                v: this.countryCode,
                f: this.tooltipTitle
            }, this.id, this.tooltipText]]);


            mapColor[i] = item.Color;//add each color item to the array - accessed in options below

        });
        var countColors = mapColor.length; //counts the colours - accessed in options below

        var options = {
            backgroundColor: {
                fill: '#FFFFFF',
                stroke: '#FFFFFF',
                strokeWidth: 0
            },
            colorAxis: {
                minValue: 0,
                maxValue: countColors ,
                colors:
                mapColor
                },
            legend: 'none',
            datalessRegionColor: '#f5f5f5',
            displayMode: 'regions',
            enableRegionInteractivity: 'true',
            resolution: 'countries',
            sizeAxis: {
                minValue: 1,
                maxValue: 1,
                minSize: 10,
                maxSize: 10
            },
            region: 'world',
            keepAspectRatio: true,
            width: 600,
            height: 400,
            tooltip: {
                textStyle: {
                    color: '#444444'
                },
                trigger: 'focus'
            }
        };


        var chart = new google.visualization.GeoChart(document.getElementById('regions_div'));

        chart.draw(data, options);

    });
}
