var $j = jQuery;

// Load the Visualization API and the chart package.

google.load("visualization", "1", {packages:["table"]});

// Set a callback to run when the Google Visualization API is loaded.
google.setOnLoadCallback(drawTable);


function drawTable() {
	$j.ajax({
		url: ajaxurl,
		data: {
			"action": "build_table"//this is the function called in functions.php
		},
		dataType: "json",
		success: function (json) {

			var data = new google.visualization.DataTable();
			data.addColumn('string', 'Name');
			data.addColumn('string', 'Type');
			data.addColumn('number', 'Amount');

			/*loop through json and add rows of content */
			for (var x in json) {
				for (var i = 0; i < json[x].length; i++) {
					data.addRow([json[x][i].name, x, json[x][i].amount, ]);
				}
			}

			var options = {
				'sortColumn': 2,
				'sortAscending': false,
				'allowHtml': true,
				'pageSize': 10,
				'page': 'enable'
			};
			var formatter = new google.visualization.NumberFormat({
				prefix: "\u00A3"
			});
			formatter.format(data, 2);
			var table = new google.visualization.Table(document.getElementById('table_div'));
			table.draw(data, options);

		}
	});


}
/*The following will resize the table in the browser*/
$j(window).resize(function () {
	drawTable();
});