<?php
/*******Version 1.0
*
*Enqueue Scripts
•Add scripts to the theme head
*
***/

function wow_jq_enews_load() {
	// use get_stylesheet_directory_uri() for child themes
	wp_enqueue_style ('ticker_style', get_template_directory_uri() .'/css/ticker-style.css' );
	wp_enqueue_script('news_ticker',  get_template_directory_uri() . '/js/jquery.ticker.js',array( 'jquery' )); //includes jquery dependencies
}

add_action( 'wp_enqueue_scripts', 'wow_jq_enews_load' );


/***
*
Adds the Javascript code to the footer automatically.  See FAQs for other options
*
***/

function wow_jq_enews_execute()
	{?>
	<script type="text/javascript">
		var $j = jQuery;
			$j(function () {
        		$j('#js-news').ticker();
			});

 	</script>

<?php }


add_action('wp_footer', 'wow_jq_enews_execute');


/***
*
Add News Ticker - uses built in SimplePie to cache files - call the function wow_add_jq_enews(); in your theme
*
***/

function wow_add_jq_enews()
{
	function cache_time($seconds)
	{
		// change the default feed cache recreation period to 1 hours
		return 3600;
	}

	add_filter( 'wp_feed_cache_transient_lifetime' , 'cache_time' );


	//Add your external feeds multiple
	$rsslist = array( 'http://mywebsite.com/feed',
					  'http://mywebsite2.com/feed'
	);

	$rss = fetch_feed($rsslist);


	//Add single feed - Uncomment and delete above
	/*
		$url = 'http://mywebsite.com/feed';
		$rss = fetch_feed($url);

	*/


	if (!is_wp_error($rss)) :
		$maxitems = $rss -> get_item_quantity(10); //gets latest 10 items This can be changed to suit your requirements
		$rss_items = $rss -> get_items(0, $maxitems);

	endif;

?>
		<!--start of displaying our feeds-->
			<ul id="js-news" class="js-hidden">
					<?php shuffle($rss_items);
							if ($maxitems === 0) echo '<li>No items.</li>';
								else foreach ( $rss_items as $item)  :?>

								<li class="news-item">
									<a href='<?php echo esc_url($item -> get_permalink()); ?>'
									   title='<?php echo esc_html($item -> get_title()); ?>'> <?php echo esc_html($item -> get_title()); ?></a>
								</li>
								<?php endforeach; ?>
								</ul>

<?php }//end jquery news ticker simplepie*/ ?>
