<?php
/*start jquery news ticker blog posts
Version 1.0
*/

/***
*
Enqueue Scripts
Add scripts to the theme head
*
***/
function wow_jq_inews_load() {
	// use get_stylesheet_directory_uri() for child themes
	wp_enqueue_style ('ticker_style', get_template_directory_uri() .'/css/ticker-style.css' );
	wp_enqueue_script('news_ticker',  get_template_directory_uri() . '/js/jquery.ticker.js',array( 'jquery' )); //includes jquery dependencies
}

add_action( 'wp_enqueue_scripts', 'wow_jq_inews_load' );


/***
*
Adds the Javascript code to the footer automatically. See FAQs for other options
*
***/

function wow_jq_inews_execute()
	{?>
	<script type="text/javascript">
		var $j = jQuery;
			$j(function () {
        		$j('#js-news').ticker();
			});

 	</script>

<?php }


add_action('wp_footer', 'wow_jq_inews_execute');

/***
*
Add News Ticker  - call the function wow_add_jq_inews(); in your theme
*
***/

function wow_add_jq_inews()
{
  $recent_posts = wp_get_recent_posts();?>

	<ul id="js-news" class="js-hidden">
		<?php foreach( $recent_posts as $recent ){
		echo '<li class="news-item"><a href="' . get_permalink($recent["ID"]) . '" title="Look '.esc_attr($recent["post_title"]).'" >' .$recent["post_title"].'</a> </li> ';
	}
?>
</ul>
<?php }	?>
