<?php
//replace with your URL
$rss = fetch_feed('http://www.worldoweb.co.uk/feed');

if (!is_wp_error($rss)) :

	$maxitems = $rss -> get_item_quantity(5); //gets latest 5 items This can be changed to suit your requirements
	$rss_items = $rss -> get_items(0, $maxitems);
endif;
?>
<?php
//grabs our post thumbnail image
	function get_first_image_url($html) {
		if (preg_match('/<img.+?src="(.+?)"/', $html, $matches)) {
			return $matches[1];
		}
	}
?>
<?php
//shortens description
function shorten($string, $length) {
	$suffix = '&hellip;';
	$short_desc = trim(str_replace(array("\r", "\n", "\t"), ' ', strip_tags($string)));
	$desc = trim(substr($short_desc, 0, $length));
	$lastchar = substr($desc, -1, 1);
	if ($lastchar == '.' || $lastchar == '!' || $lastchar == '?')
		$suffix = '';
		$desc .= $suffix;
	return $desc;
}
?>
<!--start of displaying our feeds-->
<ul class="rss-items" id="wow-feed">
<?php
		if ($maxitems == 0) echo '<li>No items.</li>';
		else foreach ( $rss_items as $item ) :
?>
<li class="item">
	<span class="rss-image">
				<?php echo '<img src="' . get_first_image_url($item -> get_content()) . '"/>'; ?>
	</span>
	<span class="data">
			<h5><a href='<?php echo esc_url($item -> get_permalink()); ?>' title='<?php echo esc_html($item -> get_title()); ?>'> <?php echo esc_html($item -> get_title()); ?></a></h5>
		<span class="date-image">&nbsp;</span>
			<small><?php echo $item -> get_date('F Y'); ?></small><!--This can be changed -->
		<span class="comment-image">&nbsp;</span>
		<small><?php $comments = $item -> get_item_tags('http://purl.org/rss/1.0/modules/slash/', 'comments'); ?><?php $number = $comments[0]['data']; ?>
				<?php //checks and displays comment count
					if ($number == '1')
						{
							 echo $number . "&nbsp;" . "Comment";
						}
					else
						{
							echo $number . "&nbsp;" . "Comments";
						}
					?>
		</small>
		<p><?php echo shorten($item -> get_description(), '150'); ?></p>
	</span>
</li>
<?php endforeach; ?>
</ul>
