<?php
	require('wp-blog-header.php');//link to your blog-header.php using relative path

	/*if you are getting 404 errors uncomment the next 2 lines*/
	//status_header(200);
	//nocache_headers();

?>
<!DOCTYPE html><!-- Doctype-->
<head><!--Opening Head Tag -->
	<meta charset="utf-8">
	<meta name="author" content="Tracy Ridge" />
	<meta name="viewport" content="width=device-width, initial-scale=1.0">

	<!--Links to CSS and JS files-->
	<link href="css/ticker-style.css" rel="stylesheet" type="text/css" />
	<script src="//ajax.googleapis.com/ajax/libs/jquery/1.11.0/jquery.min.js"></script>
	<script src="js/news_ticker.min.js"></script>
	<!--Starts our jQuery news ticker (default mode) See blog post for settings)-->
	<script type="text/javascript">
    	$(function () {
        	$('#events').ticker();
    	});
	</script>
</head><!--Closing Head tag-->
<body>
	<?php
	/*Code to fetch our WP Posts. Arguments (numberposts etc)) can be changed*/
    		$args = array( 'numberposts' => 6, 'post_status'=>"publish",'post_type'=>"post",'orderby'=>"post_date");
    		$postslist = get_posts( $args );?>
			<ul id="events" class="js-hidden">
				<?php /*Outputs our posts in a unordered list required for the jQuery script to run*/
    	 				foreach ($postslist as $post) : setup_postdata($post); ?>

           					<li class="news-item"><a href="<?php the_permalink(); ?>" title="<?php the_title(); ?>"><?php the_title(); ?></a></li>

					<?php endforeach; ?>
			</ul>
</body>
</html>
