<?php
function display_tweets($style = '', $twitter_id, $max_tweets=10,$is_child=false)
{
	if ($is_child){require(trailingslashit(get_stylesheet_directory()) . 'tmhOAuth.php');}
	else {require (trailingslashit(get_template_directory()) . 'tmhOAuth.php');}
    
    
    $tmhOAuth = new tmhOAuth(array(
        
        'consumer_key' => 'YOUR CONSUMER KEY',
        'consumer_secret' => 'YOUR CONSUMER SECRET',
        'user_token' => 'YOUR USER TOKEN',
        'user_secret' => 'YOUR USER SECRET'
    ));
    
    
    $code    = $tmhOAuth->request('GET', $tmhOAuth->url('1.1/statuses/user_timeline'), array(
        'screen_name' => $twitter_id,
        'count' => $max_tweets,
        'include_rts' => true,
        'include_entities' => true
    ));
    $twitter = '';
    /*Retrieves the file from cache*/
    $tweets  = get_transient('cfTweets');
    
    if ($tweets === false) { //if there is no cached file
        $t = json_decode($tmhOAuth->response['response'], true);
        set_transient('cfTweets', $t, 60 * 20);//set the file to be cached at 20 minute intervals, this can be changed
        $set_tweets = true; //setting this to true will enable you to parse and display the feed immediately
    }
    if (isset($set_tweets)) { //parse the feed just once as it will be cached from now on
        $tweets = json_decode($tmhOAuth->response['response'], true);
    }
    /*The function below is used to calculate the time since you last tweeted, used with 'time_since' parameter*/
    function dateDiff($time1, $time2, $precision = 6)
    {
        if (!is_int($time1)) {
            $time1 = strtotime($time1);
        }
        if (!is_int($time2)) {
            $time2 = strtotime($time2);
        }
        if ($time1 > $time2) {
            $ttime = $time1;
            $time1 = $time2;
            $time2 = $ttime;
        }
        $intervals = array(
            'year',
            'month',
            'day',
            'hour',
            'minute',
            'second'
        );
        $diffs     = array();
        foreach ($intervals as $interval) {
            $diffs[$interval] = 0;
            $ttime            = strtotime("+1 " . $interval, $time1);
            while ($time2 >= $ttime) {
                $time1 = $ttime;
                $diffs[$interval]++;
                $ttime = strtotime("+1 " . $interval, $time1);
            }
        }
        $count = 0;
        $times = array();
        foreach ($diffs as $interval => $value) {
            if ($count >= $precision) {
                break;
            }
            if ($value > 0) {
                if ($value != 1) {
                    $interval .= "s";
                }
                $times[] = $value . " " . $interval;
                $count++;
            }
        }
        return implode(", ", $times);
    }
    /*Start of displaying the tweets as a list format*/
    $twitter .= '<ul id="tweeter">';
    if (!empty($tweets)) {
        foreach ($tweets as $tweet) {
            $pubDate        = $tweet['created_at'];
            $tweet          = $tweet['text'];
            $today          = time();
            $time           = substr($pubDate, 11, 5);
            $day            = substr($pubDate, 0, 3);
            $date           = substr($pubDate, 7, 4);
            $month          = substr($pubDate, 4, 3);
            $year           = substr($pubDate, 25, 5);
            $english_suffix = date('jS', strtotime(preg_replace('/\s+/', ' ', $pubDate)));
            $full_month     = date('F', strtotime($pubDate));
            
            
            #pre-defined tags
            $default   = $full_month . $date . $year;
            $full_date = $day . $date . $month . $year;
            $ddmmyy    = $date . $month . $year;
            $mmyy      = $month . $year;
            $mmddyy    = $month . $date . $year;
            $ddmm      = $date . $month;
            
            #Time difference
            $timeDiff = dateDiff($today, $pubDate, 1);
            
            # Turn URLs into links
            $tweet = preg_replace('@(https?://([-\w\.]+)+(:\d+)?(/([\w/_\./-]*(\?\S+)?)?)?)@', '<a target="blank" title="$1" href="$1">$1</a>', $tweet);
            
            #Turn hashtags into links
            $tweet = preg_replace('/#([0-9a-zA-Z_-]+)/', "<a target='blank' title='$1' href=\"http://twitter.com/search?q=%23$1\">#$1</a>", $tweet);
            
            #Turn @replies into links
            $tweet = preg_replace("/@([0-9a-zA-Z_-]+)/", "<a target='blank' title='$1' href=\"http://twitter.com/$1\">@$1</a>", $tweet);
            
            
            $twitter .= "<li class='tweet'>" . $tweet . "<br />";
			
			if(isset($style)){
				if (!empty($style)){
				$when  = ($style == 'time_since' ? 'About' : 'On');
				$twitter.="<strong>" . $when . "&nbsp;";
			
            		switch ($style) {
                case 'eng_suff': {
                    $twitter .= $english_suffix . '&nbsp;' . $full_month;
                }
                    break;
                case 'time_since'; {
                    $twitter .= $timeDiff . "&nbsp;ago";
                }
                    break;
                case 'ddmmyy'; {
                    $twitter .= $ddmmyy;
                }
                    break;
                case 'ddmm'; {
                    $twitter .= $ddmm;
                }
                    break;
                case 'full_date'; {
                    $twitter .= $full_date;
                }
				    break;
				case 'default'; {
                    $twitter .= $default;
                }
            } //end switch statement
            $twitter .= "</strong></li>"; //end of List
				}
			}
        } //end of foreach
    } 
    else 
    {
        $twitter .= '<li>No tweets</li>';
    } //end if statement
    $twitter .= '</ul>'; //end of Unordered list (Notice it's after the foreach loop!)
    echo $twitter;
}
?>